#
# Example callback for nmos device. To use, set the property
# callback on the nmos symbol.
#
# The callback is always passed a parameter 'pyDBObject'
# which is the dbObj we have set the callback on.
#
# This code just sets a w/l property based on the fingers/fins properties.
# We assume they are integer types...
#
def nmos_cb(pyDBObject) :
	##print('callback : nmos_cb()')
	#
	# We only want to apply this callback to instances.
	# As it will be on symbol masters too...
	inst = pyDBObject.toInst()
	if inst is not None :
		fins = inst.dbGetIntProp('nfin')
		if fins < 2 :
			print('nfin must be > 1 (got ', fins, ')')
			raise ValueError
		fingers = inst.dbGetIntProp('nf')
		if fingers < 1 :
			print('nf must be > 0 (got ', fingers, ')')
			raise ValueError
		##print('Got fins = ', fins)
		##print('Got fingers = ', fingers)

		# Width is based on number of fins...
		width = fingers * ((fins-1) * 0.040) + 0.008
		# Length is fixed...
		length = 0.020

		# Convert the l/w values to a string.
		# We should use dbU from instance, not 1000
		w = str(int(width*1000)) + 'n'
		l = str(int(length*1000)) + 'n'
		##print('Replace prop w with', w)
		##print('Replace prop l with', l)

		# We use dbAddProp rather than dbReplaceProp 
		# in case the property does not exist. If the
		# property does exist, dbAddProp will replace
		# it.
		inst.dbAddProp('w', w)
		inst.dbAddProp('l', l)
		# TODO: as/ad/ps/pd
	# if inst
# def
